# Site Builder for life-tools.app

AI-powered website generator that creates Google Ads compliant websites.

## Setup Instructions

### 1. Upload Files
Upload the entire `site-builder` folder to your hosting at:
```
public_html/site-builder/
```

### 2. Configure API Keys
Edit `config.php` and add your API keys:

```php
// OpenAI API Key (required)
define('OPENAI_API_KEY', 'sk-your-openai-key-here');

// Unsplash API Key (optional - uses placeholders if not set)
define('UNSPLASH_ACCESS_KEY', 'your-unsplash-key-here');
```

### 3. Set Permissions
```bash
chmod 755 site-builder/
chmod 755 site-builder/generated/
chmod 644 site-builder/config.php
```

### 4. Create Generated Directory
Make sure the `generated` folder exists and is writable:
```bash
mkdir -p site-builder/generated
chmod 755 site-builder/generated
```

## Getting API Keys

### OpenAI API Key
1. Go to https://platform.openai.com/
2. Sign up or log in
3. Go to API Keys section
4. Create a new secret key
5. Copy and paste into config.php

### Unsplash API Key (Optional)
1. Go to https://unsplash.com/developers
2. Create a developer account
3. Create a new application
4. Copy the Access Key

## File Structure

```
site-builder/
├── index.php          # Main form interface
├── config.php         # Configuration (API keys)
├── .htaccess          # Apache config
├── api/
│   ├── generate.php       # Main API endpoint
│   ├── ContentGenerator.php   # ChatGPT integration
│   ├── TemplateEngine.php     # HTML/CSS generator
│   ├── ImageFetcher.php       # Unsplash integration
│   └── ZipBuilder.php         # ZIP creator
├── assets/
│   ├── css/
│   │   └── builder.css    # Form styles
│   └── js/
│       └── builder.js     # Form JavaScript
└── generated/         # Output ZIP files (auto-cleanup)
```

## How It Works

1. User enters: Domain, Business Type, Industry
2. System calls ChatGPT to generate all content
3. System selects appropriate design template
4. System fetches relevant images from Unsplash
5. System generates complete HTML/CSS website
6. System packages everything into ZIP
7. User downloads ready-to-upload website

## Generated Website Structure

Each generated ZIP contains:
```
website/
├── index.html         # Home page
├── about.html         # About page
├── contact.html       # Contact page
├── privacy-policy.html    # Privacy policy
├── terms-of-service.html  # Terms of service
├── css/
│   └── style.css      # All styles
├── js/
│   └── main.js        # JavaScript
└── images/            # Downloaded images
```

## Google Ads Compliance

Generated sites follow strict guidelines:
- Informational/editorial tone (not promotional)
- Substantial content depth (500+ words per page)
- No medical/legal/financial advice
- Clear purpose and value proposition
- Trust pages (Privacy, Terms)
- Cookie consent banner
- No deceptive behavior
- Fast, static HTML

## Troubleshooting

### "Failed to generate content"
- Check OpenAI API key is valid
- Check API quota/credits
- Check PHP cURL extension is enabled

### "ZIP download not working"
- Check `generated/` folder permissions (755)
- Check PHP ZIP extension is enabled
- Check disk space

### "Images not loading"
- Unsplash key not set (uses placeholders)
- Rate limit exceeded
- Network connectivity issues

## Support

For issues, check:
1. PHP error logs
2. Browser console
3. Network tab for API responses
